<?xml version="1.0"?>
<xsl:stylesheet version="1.0" 
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:xlink="http://www.w3.org/1999/xlink">
	
<xsl:output method="xml" 
            omit-xml-declaration="no" 
            standalone="no"
            doctype-system="http://www.upb.de/cs/fujab/DTDs/fujaba.dtd"
            indent="yes"/>

<!-- $Id: gxl2xml.xsl,v 1.12 2004/10/20 17:50:38 schneider Exp $ -->

  <xsl:template match="/">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="gxl">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="graph">
    <fujaba_export>
     <diagram>
      <xsl:apply-templates select="node"/>
      </diagram>
    </fujaba_export>
  </xsl:template>
    
  <!-- attributes representing comments --> 
  <xsl:template match="attr[@name='comment']">
    <comment>
      <xsl:value-of select="./string"/>
    </comment>
  </xsl:template>

  <!-- nodes representing objects -->
  <xsl:template match="node">
   <xsl:variable name="ownid">
     <xsl:value-of select="@id"/>
   </xsl:variable>
   <xsl:element name="object">
      <xsl:attribute name="id"><xsl:value-of select="@id"/></xsl:attribute>
      <xsl:for-each select="type">
        <class>
          <xsl:value-of select="@xlink:href"/>
        </class>
      </xsl:for-each>
      
       
      <!--
      <xsl:apply-templates select="attr[child::string and not(@name='comment')]"/> 
      <xsl:apply-templates select="../edge[@from=$ownid]"/>
      -->
      
      <xsl:for-each select="attr[child::string and not(@name='comment')]">
        <xsl:call-template name="s_edge"/>
      </xsl:for-each>
      
      <xsl:for-each select="../edge[@from=$ownid]">
        <xsl:call-template name="l_edge"/>
      </xsl:for-each>
      
   </xsl:element>
    
    
  </xsl:template>
  
      <!-- attributes with one subelement -->
      <xsl:template name="s_edge">
        <attribute>
          <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
          <value>
            <xsl:value-of select="child::string/text()"/>
          </value>
        </attribute>
      </xsl:template>

  <xsl:template name="string"/>   
          
  <xsl:template name="l_edge">   
    <attribute>
      <xsl:attribute name="name">
        <xsl:value-of select="child::type/@xlink:href"/>
      </xsl:attribute>
      <xsl:if test="count(attr)=0">
        <value>
          <xsl:value-of select="@to"/>
        </value>
      </xsl:if>
      <xsl:if test="count(attr)>0">
        <reference>
          <xsl:value-of select="child::attr[@name='key']/string"/> 
       </reference>
       <value>
          <xsl:value-of select="@to"/>
        </value>
      </xsl:if>
    </attribute>
  </xsl:template>

</xsl:stylesheet>


<!--  
  $Log: gxl2xml.xsl,v $
  Revision 1.12  2004/10/20 17:50:38  schneider
  Introduction of interfaces for class diagram classes

  Revision 1.1.1.1  2004/09/20 09:12:49  cschneid
  initial version

  Revision 1.11  2003/12/03 14:01:13  kudak
  DOS to UNIX

  Revision 1.10  2003/12/02 17:19:39  mahirsch
  update gxl2xml.xsl, so import works now

  Revision 1.9  2003/08/13 07:32:49  mtt
  adapted stylesheet urls to new www-serv directory

  Revision 1.8  2003/04/15 06:29:48  hoven
  latest version of gxl import/export

  Revision 1.6  2002/05/28 17:32:51  hoven
  doctype fixed for xsl transformations, some transient flags removed, dtds and xslts updated

  Revision 1.5  2002/05/27 12:21:06  hoven
  changed xml-parser, changed Hashtable to HashMap, general XML/GXL stuff

  Revision 1.4  2002/05/22 11:45:55  hoven
  xml/gxl/xmi stuff

  Revision 1.3  2002/04/25 12:32:48  hoven
  fixed gxl-stylesheets

  Revision 1.2  2002/04/24 16:42:38  hoven
  im/exporting gxl, but without validation

  Revision 1.1  2002/04/24 12:04:33  hoven
  added stylesheets

  -->
